#!/usr/local/bin/perl

sub help {

print <<ENDS
xchar.pl -- program for search big string.

Command line parametrs:
-n  --name    -- file name of book, concurent -s|--stream
                 if last parametr is -n|--name then file read from file

-s  --stream  -- read text from STDIN, concurent -n|--name
                 if last parametr is -s|--stream then file read STDIN

-c  --columns -- width text to page in chars
-p  --print   -- print to STDOUT number big string
-e  --echo    -- print to STDOUT only max big string
-h  --help    -- this is help text

Example:
 1) xcahr.pl -n any.file -c 75 -e

Makebook v 1.2b
Copyleft CNU GPL. Bootmaker SoftWARe 1999-2004.
ENDS

}

$max_columns=80;
$pr=0;
$ech=0;

$par=shift;
if(!defined $par) { help(); exit 1; }
while($par) {
  if($par eq "--name" || $par eq "-n") { $file_name=shift; }
  if($par eq "--columns" || $par eq "-c") { $max_columns=shift; }
  if($par eq "--stream" || $par eq "-s") { $file_name="STD_IN"; }
  if($par eq "--print" || $par eq "-p") { $pr=1; }
  if($par eq "--echo" || $par eq "-e") { $ech=1; }
  if($par eq "--help" || $par eq "-h") { help(); exit 0; }
  $par=shift;
}

if($file_name eq "STD_IN") { $buf=join("",<STDIN>); }
else {  
  open(FH,$file_name) or die print "\n\tNo such file $file_name!\n";
  $buf=join("",<FH>);
  close(FH);
}
close(FH);

@q=split(/\n/,$buf);
$i=1;
$j=0;
$s=0;
foreach $l (@q) {
  $m=length($l);
  $j=($j<$m)?$m:$j;
  if($m>$max_columns) {
    if($pr) { print "$i\n"; }
    $s++;
  }
  $i++;
}
if($ech) { print "$j"; }
else {
  print "total big lines: $s\n";
  print "max lenght: $j\n";
}

