#!/usr/local/bin/perl

use integer;
use Text::Wrap;

my $max_columns=75, $file_name="", $bug=chr(10), $bug1=chr(13);
my $line2page=44, $width_page=161, $part=1;
my @format=("","",chr(12));
my $i=0, $j=0, $k=0, $m=0;

sub help {

print <<ENDS
Makebook -- program for formated plain/text in landscape book format.
Usage makebook.pl require Perl 5.0.04 or greater with module Text::Wrap.

Command line parametrs:
-n  --name    -- file name of book, concurent -s|--stream
                 if last parametr is -n|--name then file read from file

-s  --stream  -- read text from STDIN, concurent -n|--name
                 if last parametr is -s|--stream then file read STDIN

-w  --width   -- width list in chars
-c  --columns -- width text to page in chars
-l  --line    -- number of line in page
-p  --part    -- number of parts in book
-h  --help    -- this is help text

Example:
 1) for print in b12prn
    makebook.pl -name book -col 75 -line 43 -width 161
    output file is book.1 & book.2
    lp -o14 -oland -db12prn book.2
    lp -o14 -oland -db12prn book.1

Makebook v 1.2a
Copyleft CNU GPL. Bootmaker SoftWARe 1999-2004.
ENDS

}

$par=shift;
if(!defined $par) { help(); exit 1; }
while($par) {
  if($par eq "--name" || $par eq "-n") { $file_name=shift; }
  if($par eq "--line" || $par eq "-l") { $line2page=shift; }
  if($par eq "--columns" || $par eq "-c") { $max_columns=shift; }
  if($par eq "--width" || $par eq "-w") { $width_page=shift; }
  if($par eq "--stream" || $par eq "-s") { $file_name="STD_IN"; }
  if($par eq "--part" || $par eq "-p") { $part=shift; }
  if($par eq "--help" || $par eq "-h") { help(); exit 0; }
  $par=shift;
}
if($file_name eq "") { help(); exit 2; }
#if((2*$max_columns+1-$width_page)>=0) { $max_columns=($width_page-1)/2; }

$j=($width_page-1)/2;
$i=($j-7)/2;
$k=$j-$i-7;
$format[0]="%".$i."s- %-3i -%".$k."s|";
$j=$width_page-($width_page-1)/2-1;
$k=($j-7)/2;
$i=$j-$k-7;
$format[0].="%".$i."s- %-3i -%".$k."s\n";

$j=($width_page-1)/2;
$i=($j-$max_columns)/2;
$k=$j-$i-$max_columns;
$format[1]="%".(($i>0)?$i:"0")."s%-".$max_columns."s%".(($k>0)?$k:"0")."s|";
$j=$width_page-($width_page-1)/2-1;
$k=($j-$max_columns)/2;
$i=$j-$k-$max_columns;
$format[1].="%".(($k>0)?$k:"0")."s%-".$max_columns."s%".(($i>0)?$i:"0")."s\n";

my $text2page=$line2page-1;
print "Read file $file_name\n";
my $buf="";
if($file_name eq "STD_IN") { $buf=join("",<STDIN>); }
else {  
  open(FH,$file_name) or die print "\n\tNo such file $file_name!\n";
  $buf=join("",<FH>);
  close(FH);
}

$Text::Wrap::columns=$max_columns;
$buf=~ s/\t/    /g;
$buf=~ s/(\S^\n)\s+/$1 /g;
$buf=~ s/(\S^\n)\s+\n+(\S^\n)/$1 $2/g;
my @tmp=split(/\n/,$buf), @abuf=(), @tmp1=();
print "Ok3\n";
foreach $l (@tmp) {
  if(length($l)>$max_columns) {
    $l =~ s/\s+/ /g;
    $buf=wrap('','',$l);
    @tmp1=split(/\n/,$buf);
    foreach $l1 (@tmp1) { push(@abuf, $l1); };
  }
  else { push(@abuf, $l); }
}

$buf="";
my $line=@abuf;
$j=$text2page*4;
my $addi=$line%$j;
my $list=$line/$j;
#my $part_line=$line/$part;
print "$line\t$j\t$addi\t$list\n";
if($addi) {
  if($line%$j) { $list++; }
  for($i=0; $i<($list*$text2page*4-$line); $i++) { push(@abuf,""); }
}
my $page=$list*4;

#$i=@abuf;
#open(FH,">2.txt");
#foreach $l (@abuf) { print FH "$l\n"; }
#close(FH);


$line=@abuf;
my @book1=(), @book2=();
#for ($p=0; $p<$part; $p++) {

  for($i=0; $i<$page/2; $i+=2) {
    $buf="";
    $buf=sprintf($format[0],"",$page-$i,"","",$i+1,"");

    for($j=0; $j<$text2page; $j++) {
      $k=$i*$text2page+$j;
      $m=$line-$i*$text2page-$text2page+$j;
      $buf.=sprintf($format[1],"",$abuf[$m],"","",$abuf[$k],"");
    }
    $buf.=$format[2];
    push(@book1,$buf);
  }

  for($i=1; $i<$page/2; $i+=2) {
    $buf="";
    $buf=sprintf($format[0],"",$i+1,"","",$page-$i,"");
    for($j=0; $j<$text2page; $j++) {
      $k=$i*$text2page+$j;
      $m=$line-$i*$text2page-$text2page+$j;
      $buf.=sprintf($format[1],"",$abuf[$k],"","",$abuf[$m],"");
    }
    $buf.=$format[2];
    push(@book2,$buf);
  }

#}

print "Part 1 is: $file_name.1\n";
open(FH,">$file_name.1");
print FH @book2;
close(FH);

print "Part 2 is: $file_name.2\n";
open(FH,">$file_name.2");
print FH @book1;
close(FH);

print "example:\nlp -o14 -oland -db12prn $file_name.1\nlp -o14 -oland -db12prn $file_name.2\n";

exit;
